document.addEventListener('DOMContentLoaded', function() {
    const startBtn = document.getElementById('startBtn');
    const stopBtn = document.getElementById('stopBtn');
    const statusDiv = document.getElementById('status');

    // 获取当前标签页
    chrome.tabs.query({active: true, currentWindow: true}, function(tabs) {
        const currentTab = tabs[0];
        
        // 检查内容脚本是否已注入
        chrome.tabs.sendMessage(currentTab.id, {action: "checkStatus"}, function(response) {
            if (chrome.runtime.lastError) {
                // 内容脚本未运行
                updateUI(false);
				console.log(chrome.runtime.lastError);
				const result = injectContentScript(currentTab.id);
				//updateUI(result);
            } else {
                updateUI(response.isActive);
            }
        });
    });

    // 开始按钮点击事件
    startBtn.addEventListener('click', function() {
        chrome.tabs.query({active: true, currentWindow: true}, function(tabs) {
            chrome.tabs.sendMessage(tabs[0].id, {action: "start"});
            updateUI(true);
        });
    });

    // 停止按钮点击事件
    stopBtn.addEventListener('click', function() {
        chrome.tabs.query({active: true, currentWindow: true}, function(tabs) {
            chrome.tabs.sendMessage(tabs[0].id, {action: "stop"});
            updateUI(false);
        });
    });

    // 更新UI状态
    function updateUI(isActive) {
        if (isActive) {
            startBtn.disabled = true;
            stopBtn.disabled = false;
            statusDiv.textContent = "状态: 运行中";
            statusDiv.className = "status active";
        } else {
            startBtn.disabled = false;
            stopBtn.disabled = true;
            statusDiv.textContent = "状态: 已停止";
            statusDiv.className = "status inactive";
        }
    }
	async function injectContentScript(tabId) {
  try {
    await chrome.scripting.executeScript({
      target: { tabId: tabId },
      files: ['content.js']
    });
    console.log('Content script注入成功');
    return true;
  } catch (error) {
    console.log('无法注入content script:', error);
    return false;
  }
}
});